from django.db.models import Q
from rest_framework import serializers, generics

from intranet.crt.api.frontend.suggest.base import SuggestLimitOffsetPagination
from django_abc_data.models import AbcService


class AbcServiceSuggestSerializer(serializers.ModelSerializer):
    class Meta:
        model = AbcService

    def to_representation(self, instance):
        return {
            'id': instance.external_id,
            'title': {
                'en': instance.name_en,
                'ru': instance.name,
            },
            'type': 'default',
        }


class AbcServiceSuggestView(generics.ListAPIView):
    serializer_class = AbcServiceSuggestSerializer
    pagination_class = SuggestLimitOffsetPagination

    def get_paginated_response(self, data):
        return self.paginator.get_paginated_response(data, self.request)

    def get_queryset(self):
        query = AbcService.objects.all()

        ids = self.request.query_params.getlist('id', [])
        search = self.request.query_params.get('search')

        if ids:
            query = query.filter(external_id__in=ids)
        elif search:
            query = query.filter(
                Q(slug__istartswith=search) |
                Q(name__istartswith=search) |
                Q(name_en__istartswith=search)
            )

        return query
