from django.conf import settings

from intranet.crt.api.frontend.suggest.base import ConstantSuggestPaginatedView
from intranet.crt.constants import CERT_TYPE
from intranet.crt.core.ca.registry import CA_REGISTRY


class CaNameSuggestView(ConstantSuggestPaginatedView):
    def prepare_object(self, ca_name):
        return {
            'id': ca_name,
            'title': {
                'en': ca_name,
                'ru': ca_name,
            },
            'type': 'default',
        }

    def get_constants(self):

        # TODO: когда сделаем CERTOR-1204, возвращать весь список settings.AVAILABLE_CA
        ca_names = [
            ca_name
            for ca_name in settings.AVAILABLE_CA
            if CERT_TYPE.HOST in CA_REGISTRY[ca_name]['kwargs']['supported_types']
        ]
        return ca_names
