from intranet.crt.api.frontend.suggest.base import ConstantSuggestPaginatedView
from intranet.crt.constants import CERT_TYPE
from intranet.crt.core.ca import get_ca


class CertTypeSuggestView(ConstantSuggestPaginatedView):
    @classmethod
    def prepare_object(self, cert_type):
        return {
            'id': cert_type,
            'title': {
                'en': CERT_TYPE.humanized[cert_type]['en'],
                'ru': CERT_TYPE.humanized[cert_type]['ru'],
            },
            'type': 'default',
        }

    def get_constants(self):
        cert_types = CERT_TYPE.active_types()
        ca_name = self.request.GET.get('ca_name', None)
        if ca_name:
            ca = get_ca(ca_name)
            cert_types = [type_ for type_ in cert_types if type_ in ca.supported_types]

        return cert_types
