from rest_framework import serializers, generics

from intranet.crt.api.frontend.suggest.base import SuggestLimitOffsetPagination
from intranet.crt.core.models import Host


class HostSuggestSerializer(serializers.ModelSerializer):
    class Meta:
        model = Host

    def to_representation(self, instance):
        return {
            'id': instance.hostname,
            'title': {
                'en': instance.hostname,
                'ru': instance.hostname,
            },
            'type': 'default',
        }


class HostSuggestView(generics.ListAPIView):
    serializer_class = HostSuggestSerializer
    pagination_class = SuggestLimitOffsetPagination

    def get_paginated_response(self, data):
        return self.paginator.get_paginated_response(data, self.request)

    def get_queryset(self):
        query = Host.objects.all()

        slugs = self.request.query_params.getlist('id', [])
        search = self.request.query_params.get('search')

        if slugs:
            query = query.filter(hostname__in=slugs)
        elif search:
            search = search.lower()
            query = query.filter(hostname__startswith=search)

        return query
