from django.conf.urls import url, include

from intranet.crt.api.frontend.certificates import (
    CertificateList,
    CertificateDetail,
    CertificateDownload,
    CertificateOperations,
)
from intranet.crt.api.frontend.fields import RequestFieldsView
from intranet.crt.api.frontend.suggest import urls as suggest_urls
from intranet.crt.api.frontend.userdata import UserDataView


urlpatterns = [
    url(r'^suggest/', include(suggest_urls, namespace='suggest')),
    url(r'^fields/$', RequestFieldsView.as_view(), name='fields'),
    url(r'^userdata/$', UserDataView.as_view(), name='userdata'),
    url(r'^certificates/$', CertificateList.as_view(), name='certificates'),
    url(r'^certificate/(?P<pk>[0-9]+)/$', CertificateDetail.as_view(), name='certificate'),
    url(r'^certificate/(?P<pk>[0-9]+)/download/$', CertificateDownload.as_view(), name='certificate-download'),
    url(r'^certificate/(?P<pk>[0-9]+)/operations/$', CertificateOperations.as_view(), name='certificate-operations'),
]
