from django_yauth.util import get_passport_url
from django_yauth import exceptions
from rest_framework.generics import RetrieveAPIView
from rest_framework.serializers import ModelSerializer

from intranet.crt.api.base.exceptions import PleaseRedirectToPassport
from intranet.crt.api.base.views import NoAuthenticationMixin
from intranet.crt.users.models import CrtUser


class UserDataSerializer(ModelSerializer):
    class Meta:
        model = CrtUser

    def to_representation(self, instance):
        return {
            'username': instance.username,
            'first_name': {
                'en': instance.first_name,
                'ru': instance.first_name_ru,
            },
            'last_name': {
                'en': instance.last_name,
                'ru': instance.last_name_ru,
            },
            'email': instance.email,
            'lang_ui': instance.lang_ui,
        }


class UserDataView(NoAuthenticationMixin, RetrieveAPIView):
    serializer_class = UserDataSerializer

    def get_object(self):
        authenticated = False
        try:
            if self.request.user.is_authenticated():
                authenticated = True
        except exceptions.TwoCookiesRequired:  # no sessionid2 or invalid (expired) cookies
            pass

        if not authenticated:
            # бросаем именно этот эксепшен, т.к. более логичный NotAuthenticated DRF перехватывает
            # и превращает в 403 вместо 401
            raise PleaseRedirectToPassport(detail={
                'detail': 'Authentication credentials were not provided.',
                'passport-url': get_passport_url('create', None, self.request, retpath=False)
            })

        if self.request.yauser.need_reset:
            raise PleaseRedirectToPassport(detail={
                'detail': 'Authentication credentials should be updated',
                'passport-url': get_passport_url('refresh', None, self.request, retpath=False)
            })

        return self.request.user
