import re

from django.forms import widgets
from django_abc_data.models import AbcService
from rest_framework import relations, fields


class DownloadField(relations.HyperlinkedIdentityField):
    def __init__(self, force_format=False, *args, **kwargs):
        self.force_format = force_format
        super(DownloadField, self).__init__(*args, **kwargs)

    def to_representation(self, value):
        if self.force_format:
            old_format = self.context.get('format')
            self.context['format'] = self.format

        result = super(DownloadField, self).to_representation(value)

        if self.force_format:
            self.context['format'] = old_format

        return result


class AbcServiceField(relations.SlugRelatedField):
    widget = widgets.TextInput

    def __init__(self, queryset=None, **kwargs):
        if queryset is None:
            queryset = AbcService.objects.all()
        super(AbcServiceField, self).__init__(queryset=queryset, **kwargs)
