from django import forms
from django.forms import widgets
from django_abc_data.models import AbcService

from intranet.crt.tags.models import CertificateTag


class CertificateUpdateForm(forms.Form):
    abc_service = forms.ModelChoiceField(
        label='Id ABC-сервиса',
        queryset=AbcService.objects.all(),
        to_field_name='external_id',
        widget=widgets.TextInput,
        required=False,
    )
    manual_tags = forms.ModelMultipleChoiceField(
        label='Теги сертификата',
        queryset=CertificateTag.objects.all(),
        to_field_name='name',
        widget=widgets.SelectMultiple,
        required=False,
    )
    append_tags_only = forms.BooleanField(
        label='Не перезатирать старые теги',
        required=False,
    )
