from rest_framework import generics, exceptions

from intranet.crt.constants import TASK_TYPE
from intranet.crt.core.models import Certificate, TaskTimestamp
from intranet.crt.utils.time import timestamp_to_aware, aware_to_timestamp
from intranet.crt.tags.serializers import NocCertSerializer


class LastNocCertificatesView(generics.ListAPIView):
    serializer_class = NocCertSerializer
    pagination_class = None

    def get(self, *args, **kwargs):
        last_sync = TaskTimestamp.objects.get_last(TASK_TYPE.SYNC_CVS_TAGS)
        if last_sync is None:
            raise exceptions.APIException('Cannot find last tags upload')

        self.last_sync = last_sync.start

        return super(LastNocCertificatesView, self).get(*args, **kwargs)

    def get_serializer(self, instance=None, many=None, *args, **kwargs):
        return NocCertSerializer(instance=instance, many=many, last_sync=self.last_sync)

    def get_queryset(self, *args, **kwargs):
        default_since = aware_to_timestamp(self.last_sync)
        try:
            since_timestamp = int(self.request.query_params.get('since', default_since))
            since = timestamp_to_aware(since_timestamp)
        except (ValueError, TypeError):
            raise exceptions.ParseError('since field must be a unixtime')

        return Certificate.objects.for_noc_endpoint(since=since)
