from rest_framework import fields

from intranet.crt.utils.dns import get_aliases


class ARecordField(fields.CharField):
    # TODO(v-sopov): проверить это на тестинге
    def get_attribute(self, instance):
        if not instance:
            return

        try:
            return get_aliases(instance.host)[0]
        except Exception:
            return instance.host


class LastValidationField(fields.CharField):
    """Поле содержит дату последнего зафиксированного факта валидации
    хоста. Работает путем анализа истории."""
    def get_attribute(self, instance):
        if not instance:
            return

        validation = instance.history.filter(action='validated').order_by('-created')[:1]
        if validation:
            return validation[0].created
