from rest_framework import serializers, relations, fields
from intranet.crt.api.v1.hosttoapprove.fields import ARecordField, LastValidationField
from intranet.crt.core.models import HostToApprove, HostToApproveHistory, HostValidationCode


class HostToApproveSerializer(serializers.ModelSerializer):
    url = relations.HyperlinkedIdentityField(
        view_name='api:certificate-detail',
        lookup_field='pk',
        read_only=True
    )
    host = ARecordField()

    class Meta:
        model = HostToApprove
        fields = ('id', 'host', 'url')


class HostToApproveDnsSerializer(serializers.ModelSerializer):
    host = ARecordField()
    code = fields.ReadOnlyField(source='get_code')

    class Meta:
        model = HostToApprove
        fields = ('host', 'code', 'is_waiting_for_validation')


class HostValidationCodeSerializer(serializers.ModelSerializer):
    host = fields.ReadOnlyField(source='host.host')

    class Meta:
        model = HostValidationCode
        fields = ('host', 'code', 'is_waiting_for_validation')


class HostHistorySerializer(serializers.ModelSerializer):
    host = fields.ReadOnlyField(source='host.host')
    certificate = fields.ReadOnlyField(source='certificate.common_name')
    certificate_uri = relations.HyperlinkedRelatedField(
        source='certificate',
        view_name='api:certificate-detail',
        lookup_field='pk',
        read_only=True,
    )

    class Meta:
        model = HostToApproveHistory
        fields = ('host', 'action', 'created', 'validation_code', 'certificate', 'certificate_uri')


class ManagedHostSerializer(serializers.ModelSerializer):
    class Meta:
        model = HostToApprove
        fields = ('host', 'last_validation')

    last_validation = LastValidationField()
