import collections

from django.contrib.auth.models import Permission
from rest_framework import decorators, response, views


@decorators.api_view(('GET',))
def index(request, format=None):
    from rest_framework.reverse import reverse
    return response.Response({
        'hosts-to-approve': reverse('api:hosts-to-approve2', request=request),
        'auto-managed-hosts': reverse('api:auto-managed-hosts', request=request),
    })


class PermissionsView(views.APIView):
    def get(self, request, format=None):
        result = collections.defaultdict(dict)

        if request.user.is_superuser:
            perms = Permission.objects.all()
        else:
            perms = set(request.user.user_permissions.all())
            for group in request.user.groups.all():
                perms.update(group.permissions.all())

        for perm in perms:
            result[perm.content_type.app_label][perm.codename] = True

        return response.Response(result)
