import os

from django.conf import settings
from django.http import HttpResponse, HttpResponseForbidden
from django.template import Context
from django.template import Template
from rest_framework import generics

from intranet.crt.core.models import Certificate


class MobvpnTlsKey(generics.GenericAPIView):
    model = Certificate
    queryset = Certificate.objects.all()

    def get(self, request, *args, **kwargs):
        self.get_object()

        if request.META.get('HTTP_X_MOBVPN_SECRET') != settings.MOBVPN_SECRET_TOKEN:
            return HttpResponseForbidden('Secret token required')

        content = open(settings.MOBVPN_TLS_KEY_FILENAME).read()
        return HttpResponse(content, content_type='text/plain')


class MobvpnCaPem(generics.GenericAPIView):
    model = Certificate
    queryset = Certificate.objects.all()

    def get(self, request, *args, **kwargs):
        self.get_object()
        filename = os.path.join(settings.CRT_CA_CHAINS_PATH, 'mobvpn-ca.pem')
        content = open(filename).read()
        return HttpResponse(content, content_type='application/x-pem-file')


class ConfigOvpn(generics.GenericAPIView):
    model = Certificate
    queryset = Certificate.objects.all()

    def get(self, request, *args, **kwargs):
        self.get_object()

        with open(settings.OVPN_CONFIG_FILENAME) as t_file:
            template_string = t_file.read()

        template = Template(template_string)
        context = Context({'username': request.user.username})
        content = template.render(context)

        return HttpResponse(content, content_type='text/plain')
