from django.http import HttpResponseNotFound
from django.utils import timezone
from rest_framework import generics, response, renderers
from rest_framework_xml.renderers import XMLRenderer

from intranet.crt.users.models import CrtUser


class UserSubject(generics.GenericAPIView):
    """ Нужно поговорить с хелпами и выпилить эту ручку
    """
    renderer_classes = (renderers.BrowsableAPIRenderer, renderers.JSONRenderer, XMLRenderer)

    def get(self, request, **kwargs):
        username = kwargs['username']
        try:
            user = CrtUser.objects.get(in_hiring=False, username=username)
        except CrtUser.DoesNotExist:
            return HttpResponseNotFound('Can not find user on Staff')

        attributes = {
            'username': username,
            'updated': timezone.now(),
            'common_name': '{user.first_name} {user.last_name}'.format(user=user),
            'email': user.email,
            'state': 'Moscow',
            'organization': 'Yandex',
            'country': user.country,
            'city': user.city,
            'unit': user.unit,
        }
        return response.Response(attributes)
