from django.conf.urls import url

from intranet.crt.api.v1.misc.views import index, PermissionsView
from intranet.crt.api.v1.hosttoapprove.views import (
    HostsToApproveList2, HostsToApproveList, HostToApproveDetail, AutoManagedHostsList, HostToApproveHistoryList
)
from intranet.crt.api.v1.mobvpn.views import ConfigOvpn, MobvpnCaPem, MobvpnTlsKey
from intranet.crt.api.v1.certificates.views.certificates import CertificateList, CertificateDetail, CertificateDownload
from intranet.crt.api.v1.certificates.views.noc import LastNocCertificatesView
from intranet.crt.api.v1.certificates.views.reissue import ReissueCertificateView
from intranet.crt.api.v1.approverequests.views import ApproveRequestView
from intranet.crt.api.v1.subjects.views import UserSubject


app_name = 'api'
urlpatterns = [
    url(r'^$', index, name='index'),

    # TODO убрать ручку с .xml, когда Олег Горохов поправит свои скрипты
    url(r'^hosts-to-approve.xml$', HostsToApproveList2.as_view(), name='hosts-to-approve'),
    url(r'^hosts/to-approve/$', HostsToApproveList.as_view(), name='hosts-to-approve2'),
    url(r'^hosts/to-approve/(?P<pk>[0-9]+)/$', HostToApproveDetail.as_view(), name='host-to-approve-detail'),
    url(r'^hosts/to-approve/(?P<pk>[0-9]+)/history/$', HostToApproveHistoryList.as_view(), name='host-to-approve-history'),
    url(r'^hosts/auto-managed/$', AutoManagedHostsList.as_view(), name='auto-managed-hosts'),
    url(r'^user/(?P<username>.*?).(?P<format>api|xml|json)$', UserSubject.as_view(), name='userfields-detail'),
    url(r'^certificate/$', CertificateList.as_view(), name='certificates'),
    url(r'^certificate/(?P<pk>[0-9]+)/$', CertificateDetail.as_view(), name='certificate-detail'),
    url(r'^certificate/(?P<pk>[0-9]+)/download$', CertificateDownload.as_view(), name='certificate-download2'),
    url(r'^certificate/(?P<pk>[0-9]+)/download\.(?P<format>[a-z]+)$', CertificateDownload.as_view(), name='certificate-download'),
    url(r'^certificate/(?P<pk>[0-9]+)/download/tls\.key$', MobvpnTlsKey.as_view(), name='certificate-tls-key'),
    url(r'^certificate/(?P<pk>[0-9]+)/download/ca\.pem$', MobvpnCaPem.as_view(), name='certificate-ca-pem'),
    url(r'^certificate/(?P<pk>[0-9]+)/download/config\.ovpn$', ConfigOvpn.as_view(), name='certificate-config-ovpn'),
    url(r'^permissions/$', PermissionsView.as_view(), name='permissions'),
    url(r'^approve-request/(?P<pk>[0-9]+)/$', ApproveRequestView.as_view(), name='approve-request'),
    url(r'^reissue/$', ReissueCertificateView.as_view(), name='reissue'),
    url(r'^last-tags/$', LastNocCertificatesView.as_view(), name='reissue'),
]
