import traceback

from intranet.crt.exceptions import CrtException, CrtError


class CaException(CrtException):
    pass


class RetryCaException(CaException):
    """ Исключение после которого необходимо повторить запрос к CA"""
    pass


class CaError(CaException, CrtError):
    """ Ожидаемая ошибка с точки зрения разработки """

    def get_message(self):
        return str(self)


class Ca429Error(CaError):
    def __init__(self, message, retry_after=None, *args, **kwargs):
        self.retry_after = retry_after
        super(Ca429Error, self).__init__(message, *args, **kwargs)


class ValidationCaError(CaException):  # Заменить на CaError
    """ Ошибка входных данных """
    pass


class FatalCaError(CaError):
    """ Непредвиденная ошибка. Вслучае возникновения нужно обернуть в CaError """

    def get_message(self):
        return traceback.format_exc()
