import os

from django.conf import settings

from intranet.crt.constants import CERT_TYPE, CA_NAME
from intranet.crt.core.ca.certum import CertumProductionCA, CertumTestCA
from intranet.crt.core.ca.globalsign import GlobalSignProductionCA, GlobalSignTestCA
from intranet.crt.core.ca.internal import InternalCA, RcInternalCA, YcInternalCA, InternalTestCA, CbInternalCA
from intranet.crt.core.ca.test import TestCA, ApprovableTestCA

CA_REGISTRY = {
    CA_NAME.INTERNAL_CA: {
        'cls': InternalCA,
        'kwargs': {
            'username': 'cert-web',
            'password': getattr(settings, 'INTERNAL_CA_PASSWORD', ''),
            'request_url': 'https://zanzibar-caint.ld.yandex.ru',
            'revoke_url': 'https://zanzibar-caint.ld.yandex.ru:7777/CertificateRevoker/json/reply/Revoke?format=json',
            'supported_types': {
                CERT_TYPE.HOST,
                CERT_TYPE.PC,
                CERT_TYPE.BANK_PC,
                CERT_TYPE.ZOMB_PC,
                CERT_TYPE.COURTECY_VPN,
                CERT_TYPE.LINUX_PC,
                CERT_TYPE.LINUX_TOKEN,
                CERT_TYPE.MOBVPN,
                CERT_TYPE.BOTIK,
                CERT_TYPE.NINJA,
                CERT_TYPE.NINJA_EXCHANGE,
                CERT_TYPE.ASSESSOR,
                CERT_TYPE.CLIENT_SERVER,
                CERT_TYPE.BANK_CLIENT_SERVER,
                CERT_TYPE.POSTAMATE,
                CERT_TYPE.MDB,
                CERT_TYPE.SDC,
                CERT_TYPE.VPN_1D,
                CERT_TYPE.VPN_TOKEN,
                CERT_TYPE.IMDM,
                CERT_TYPE.ZOMBIE,
                CERT_TYPE.TPM_SMARTCARD_1C,
            },
        },
    },
    CA_NAME.INTERNAL_TEST_CA: {
        'cls': InternalTestCA,
        'kwargs': {
            'username': r'LDTESTCA\test-1',
            'password': getattr(settings, 'INTERNAL_CA_PASSWORD', ''),
            'request_url': 'https://testlab-n3-v7.yandex.net',
            'revoke_url': 'https://testlab-n3-v7.yandex.net/CertificateRevoker/json/reply/Revoke?format=json',
            'supported_types': {
                CERT_TYPE.HOST,
                CERT_TYPE.PC,
                CERT_TYPE.BANK_PC,
                CERT_TYPE.ZOMB_PC,
                CERT_TYPE.COURTECY_VPN,
                CERT_TYPE.LINUX_PC,
                CERT_TYPE.LINUX_TOKEN,
                CERT_TYPE.MOBVPN,
                CERT_TYPE.BOTIK,
                CERT_TYPE.NINJA,
                CERT_TYPE.NINJA_EXCHANGE,
                CERT_TYPE.HYPERCUBE,
                CERT_TYPE.ASSESSOR,
                CERT_TYPE.CLIENT_SERVER,
                CERT_TYPE.BANK_CLIENT_SERVER,
                CERT_TYPE.POSTAMATE,
                CERT_TYPE.SDC,
                CERT_TYPE.RC_SERVER,
                CERT_TYPE.YC_SERVER,
                CERT_TYPE.MDB,
                CERT_TYPE.VPN_1D,
                CERT_TYPE.VPN_TOKEN,
                CERT_TYPE.IMDM,
                CERT_TYPE.ZOMBIE,
                CERT_TYPE.TPM_SMARTCARD_1C,
                CERT_TYPE.TEMP_PC,
            },
        },
    },
    CA_NAME.RC_INTERNAL_CA: {
        'cls': RcInternalCA,
        'kwargs': {
            'username': 'cert-web',
            'password': getattr(settings, 'INTERNAL_CA_PASSWORD', ''),
            'request_url': 'https://zanzibar-rc.ld.yandex.ru',
            'revoke_url': 'https://zanzibar-rc.ld.yandex.ru:7777/CertificateRevoker/json/reply/Revoke?format=json',
            'supported_types': {
                CERT_TYPE.RC_SERVER,
            },
        },
    },
    CA_NAME.YC_INTERNAL_CA: {
        'cls': YcInternalCA,
        'kwargs': {
            'username': r'LD\cert-web',
            'password': getattr(settings, 'INTERNAL_CA_PASSWORD', ''),
            'request_url': 'https://zanzibar-cl.ld.yandex.ru',
            'revoke_url': 'https://zanzibar-cl.ld.yandex.ru:7777/CertificateRevoker/json/reply/Revoke?format=json',
            'supported_types': {
                CERT_TYPE.YC_SERVER,
            },
        },
    },
    CA_NAME.CB_INTERNAL_CA: {
        'cls': CbInternalCA,
        'kwargs': {
            'username': r'LD\cert-web',
            'password': getattr(settings, 'INTERNAL_CA_PASSWORD', ''),
            'request_url': 'https://zanzibar-cb.ld.yandex.ru',
            'revoke_url': 'https://zanzibar-cb.ld.yandex.ru:7777/CertificateRevoker/json/reply/Revoke?format=json',
            'supported_types': {
                CERT_TYPE.HYPERCUBE,
                CERT_TYPE.TEMP_PC,
            },
        },
    },
    CA_NAME.CERTUM_TEST_CA: {
        'cls': CertumTestCA,
        'kwargs': {
            'wsdl_url': os.environ.get('CERTUM_TEST_WSDL_URL', 'https://gs.test.certum.pl/service/PartnerApi.wsdl'),
            'service_url': os.environ.get('CERTUM_TEST_SERVICE_URL', 'https://gs.test.certum.pl/service/PartnerApi'),
            'username': os.environ.get('CERTUM_TEST_USERNAME', 'pki@yandex-team.ru'),
            'password': os.environ.get('CERTUM_TEST_PASSWORD', ''),
            'supported_types': {
                CERT_TYPE.HOST,
            },
        }
    },
    CA_NAME.CERTUM_PRODUCTION_CA: {
        'cls': CertumProductionCA,
        'kwargs': {
            'wsdl_url': os.environ.get('CERTUM_WSDL_URL', 'https://gs.certum.pl/service/PartnerApi.wsdl'),
            'service_url': os.environ.get('CERTUM_SERVICE_URL', 'https://gs.certum.pl/service/PartnerApi'),
            'username': os.environ.get('CERTUM_USERNAME', 'pki@yandex-team.ru'),
            'password': os.environ.get('CERTUM_PASSWORD', ''),
            'supported_types': {
                CERT_TYPE.HOST,
            },
        }
    },
    CA_NAME.GLOBALSIGN_TEST_CA: {
        'cls': GlobalSignTestCA,
        'kwargs': {
            'hostname': 'test-gcc.globalsign.com',
            'username': 'PAR43758_pkiuser',
            'password': getattr(settings, 'GLOBALSIGN_PASSWORD', ''),
            'profile_id': '43758_SMS2_2638',
            'supported_types': {
                CERT_TYPE.HOST,
            },
        }
    },
    CA_NAME.GLOBALSIGN_PRODUCTION_CA: {
        'cls': GlobalSignProductionCA,
        'kwargs': {
            'hostname': 'system.globalsign.com',
            'username': 'PAR132479_api',
            'password': getattr(settings, 'GLOBALSIGN_PASSWORD', ''),
            'profile_id': '132479_SMS2_4152',
            'supported_types': {
                CERT_TYPE.HOST,
            },
        }
    },
    CA_NAME.TEST_CA: {
        'cls': TestCA,
        'kwargs': {
            'supported_types': {
                CERT_TYPE.HOST,
                CERT_TYPE.YC_SERVER,
                CERT_TYPE.PC,
                CERT_TYPE.BANK_PC,
                CERT_TYPE.ZOMB_PC,
                CERT_TYPE.COURTECY_VPN,
                CERT_TYPE.LINUX_PC,
                CERT_TYPE.LINUX_TOKEN,
                CERT_TYPE.MOBVPN,
                CERT_TYPE.BOTIK,
                CERT_TYPE.NINJA,
                CERT_TYPE.NINJA_EXCHANGE,
                CERT_TYPE.HYPERCUBE,
                CERT_TYPE.ASSESSOR,
                CERT_TYPE.CLIENT_SERVER,
                CERT_TYPE.BANK_CLIENT_SERVER,
                CERT_TYPE.POSTAMATE,
                CERT_TYPE.SDC,
                CERT_TYPE.RC_SERVER,
                CERT_TYPE.VPN_1D,
                CERT_TYPE.VPN_TOKEN,
                CERT_TYPE.IMDM,
                CERT_TYPE.ZOMBIE,
                CERT_TYPE.MDB,
                CERT_TYPE.TPM_SMARTCARD_1C,
                CERT_TYPE.TEMP_PC,
            },
        },
    },
    CA_NAME.APPROVABLE_TEST_CA: {
        'cls': ApprovableTestCA,
        'kwargs': {
            'supported_types': {
                CERT_TYPE.HOST,
            },
        },
    },
}


def get_ca_cls(name):
    return CA_REGISTRY[name]['cls']


def get_ca(name):
    cls = get_ca_cls(name)
    kwargs = CA_REGISTRY[name].get('kwargs', {})
    return cls(**kwargs)


def get_async_ca_names():
    return [ca_name for ca_name in settings.AVAILABLE_CA if get_ca_cls(ca_name).IS_ASYNC]
