from django.conf import settings


def misc(request):
    domain = request.get_host()

    current_url = ('https://%s%s' % (domain, request.path)).encode('utf-8')
    if request.GET:
        current_url += '?' + request.GET.urlencode()

    return {
        'host': domain,
        'is_index': request.path == '/',
        'current_url': current_url,
        'settings': settings
    }
