from intranet.crt.constants import CERT_TYPE
from intranet.crt.core.controllers.certificates.base import (
    BaseCertificateController, BaseCsrCertificateController
)
from intranet.crt.core.controllers.certificates.assessor import AssessorCertificateController
from intranet.crt.core.controllers.certificates.bank_pc import BankPcCertificateController
from intranet.crt.core.controllers.certificates.botik import BotikCertificateController
from intranet.crt.core.controllers.certificates.client_server import ClientServerCertificateController
from intranet.crt.core.controllers.certificates.bank_client_server import BankClientServerCertificateController
from intranet.crt.core.controllers.certificates.courtecy_vpn import CourtecyVPNCertificateController
from intranet.crt.core.controllers.certificates.host import HostCertificateController
from intranet.crt.core.controllers.certificates.imdm import ImdmCertificateController
from intranet.crt.core.controllers.certificates.linux_pc import LinuxPcCertificateController
from intranet.crt.core.controllers.certificates.linux_token import LinuxTokenCertificateController
from intranet.crt.core.controllers.certificates.mdb import MdbCertificateController
from intranet.crt.core.controllers.certificates.mobvpn import MobvpnCertificateController
from intranet.crt.core.controllers.certificates.pc import PcCertificateController
from intranet.crt.core.controllers.certificates.zomb_pc import ZombPcCertificateController
from intranet.crt.core.controllers.certificates.rc_server import RcServerCertificateController
from intranet.crt.core.controllers.certificates.postamate import PostamateCertificateController
from intranet.crt.core.controllers.certificates.sdc import SdcCertificateController
from intranet.crt.core.controllers.certificates.tpm_smartcard_1c import TpmSmartcard1CCertificateController
from intranet.crt.core.controllers.certificates.yc_server import YcServerCertificateController
from intranet.crt.core.controllers.certificates.vpn_token import VpnTokenCertificateController
from intranet.crt.core.controllers.certificates.vpn_1d import Vpn1DCertificateController
from intranet.crt.core.controllers.certificates.win_pc_auto import WinPcAutoCertificateController
from intranet.crt.core.controllers.certificates.zombie import ZombieCertificateController
from intranet.crt.core.controllers.certificates.ninja import (
    NinjaCertificateController,
    NinjaExchangeCertificateController,
)
from intranet.crt.core.controllers.certificates.hypercube import HypercubeCertificateController
from intranet.crt.core.controllers.certificates.temp_pc import TempPcCertificateController
from intranet.crt.core.controllers.certificates.win_wh_shared import WinWhSharedCertificateController

CERTIFICATE_CONTROLLERS = {
    CERT_TYPE.HOST: HostCertificateController,
    CERT_TYPE.IMDM: ImdmCertificateController,
    CERT_TYPE.PC: PcCertificateController,
    CERT_TYPE.BANK_PC: BankPcCertificateController,
    CERT_TYPE.ZOMB_PC: ZombPcCertificateController,
    CERT_TYPE.COURTECY_VPN: CourtecyVPNCertificateController,
    CERT_TYPE.LINUX_PC: LinuxPcCertificateController,
    CERT_TYPE.LINUX_TOKEN: LinuxTokenCertificateController,
    CERT_TYPE.MOBVPN: MobvpnCertificateController,
    CERT_TYPE.NINJA: NinjaCertificateController,
    CERT_TYPE.NINJA_EXCHANGE: NinjaExchangeCertificateController,
    CERT_TYPE.ASSESSOR: AssessorCertificateController,
    CERT_TYPE.RC_SERVER: RcServerCertificateController,
    CERT_TYPE.YC_SERVER: YcServerCertificateController,
    CERT_TYPE.VPN_TOKEN: VpnTokenCertificateController,
    CERT_TYPE.VPN_1D: Vpn1DCertificateController,
    CERT_TYPE.BOTIK: BotikCertificateController,
    CERT_TYPE.CLIENT_SERVER: ClientServerCertificateController,
    CERT_TYPE.BANK_CLIENT_SERVER: BankClientServerCertificateController,
    CERT_TYPE.WIN_PC_AUTO: WinPcAutoCertificateController,
    CERT_TYPE.ZOMBIE: ZombieCertificateController,
    CERT_TYPE.POSTAMATE: PostamateCertificateController,
    CERT_TYPE.SDC: SdcCertificateController,
    CERT_TYPE.HYPERCUBE: HypercubeCertificateController,
    CERT_TYPE.MDB: MdbCertificateController,
    CERT_TYPE.TPM_SMARTCARD_1C: TpmSmartcard1CCertificateController,
    CERT_TYPE.TEMP_PC: TempPcCertificateController,
    CERT_TYPE.WIN_WH_SHARED: WinWhSharedCertificateController,
}


def get_certificate_controller(certificate):
    controller_class = CERTIFICATE_CONTROLLERS.get(certificate.type.name, BaseCertificateController)
    return controller_class(certificate)
