from intranet.crt.constants import CERT_TYPE, CERT_TEMPLATE
from intranet.crt.core.controllers.certificates import BaseCertificateController


TEMPLATES_WITH_TTL = {
    3: CERT_TEMPLATE.USER_PDAS_3D,
    5: CERT_TEMPLATE.USER_PDAS_5D,
    10: CERT_TEMPLATE.USER_PDAS_10D,
    30: CERT_TEMPLATE.USER_PDAS_30D,
}


class HypercubeCertificateController(BaseCertificateController):
    cert_type = CERT_TYPE.HYPERCUBE
    default_internal_ca_template = None
    revoke_for_dismissed_user = False

    def get_internal_ca_template(self):
        return TEMPLATES_WITH_TTL.get(self.cert.desired_ttl_days)
