import re
import collections

from django.db.models import Count

from intranet.crt.constants import CERT_TYPE, CERT_TEMPLATE
from intranet.crt.core.controllers.certificates import BaseCertificateController
from intranet.crt.core.models import Certificate


class ImdmCertificateController(BaseCertificateController):
    cert_type = CERT_TYPE.IMDM
    default_internal_ca_template = CERT_TEMPLATE.USER_IMDM
    revoke_for_dismissed_user = True

    common_name_re = re.compile(r'^([\w._-]+)@ld\.yandex\.ru$')

    @classmethod
    def duplicate_certificates(cls):
        """ Дубликатами считаются сертификаты с одинаковым pc_serial_number """

        duplicate_pc_serials = (
            Certificate.objects
            .values('pc_serial_number')
            .annotate(duplicate_count=Count('pc_serial_number'))
            .active(cls.cert_type)
            .filter(duplicate_count__gt=1)
            .values_list('pc_serial_number', flat=True)
        )

        db_duplicate_certificates = (
            Certificate.objects
            .active(cls.cert_type)
            .filter(pc_serial_number__in=duplicate_pc_serials)
            .order_by('added')
        )

        duplicate_certificates = collections.defaultdict(list)
        for cert in db_duplicate_certificates:
            duplicate_certificates[cert.pc_serial_number].append(cert)

        cert_duplicates = {}
        for certificates in duplicate_certificates.values():
            new_cert = certificates.pop()
            cert_duplicates[new_cert] = certificates

        return cert_duplicates
