import abc

from intranet.crt.constants import CERT_TYPE, CERT_TEMPLATE
from intranet.crt.core.controllers.certificates import BaseCertificateController


class BaseNinjaCertificateController(BaseCertificateController, metaclass=abc.ABCMeta):
    default_internal_ca_template = CERT_TEMPLATE.USER_PDAS
    revoke_for_dismissed_user = True


class NinjaCertificateController(BaseNinjaCertificateController):
    cert_type = CERT_TYPE.NINJA


class NinjaExchangeCertificateController(BaseNinjaCertificateController):
    cert_type = CERT_TYPE.NINJA_EXCHANGE
