from django.db import transaction

from intranet.crt.constants import CERT_TYPE, CERT_TEMPLATE, CERT_STATUS
from intranet.crt.core.controllers.certificates import BaseCertificateController
from intranet.crt.core.models import Certificate


class TempPcCertificateController(BaseCertificateController):
    cert_type = CERT_TYPE.TEMP_PC
    default_internal_ca_template = CERT_TEMPLATE.USER_PDAS_1D
    revoke_for_dismissed_user = True

    @transaction.atomic
    def issue(self):
        # Не больше одного сертификата на пользователя
        for cert in Certificate.objects.filter(
            ca_name=self.cert.ca_name,
            type=self.cert.type,
            user=self.cert.user,
            status=CERT_STATUS.ISSUED
        ).exclude(
            pk=self.cert.pk
        ):
            cert.controller.revoke(self.cert.requester, 'by new certificate request')

        self.ca.issue(self.cert)
