import re

from intranet.crt.constants import CERT_TYPE, CERT_TEMPLATE
from intranet.crt.core.controllers.certificates import BaseCertificateController


class ZombieCertificateController(BaseCertificateController):
    cert_type = CERT_TYPE.ZOMBIE
    default_internal_ca_template = CERT_TEMPLATE.ZOMBIE
    revoke_for_dismissed_user = False

    common_name_re = re.compile(r'^(zomb-[\w._-]+)@ld\.yandex\.ru$')
    csr_unit_re = re.compile(r'^zomb$')
