from django.db import models
from django.conf import settings
from django.utils.encoding import force_bytes, force_text

from intranet.crt.utils.ssl import PrivateKeyCryptographer


class EncryptedPrivateKeyField(models.TextField):
    cryptographer = PrivateKeyCryptographer(settings.CRT_PRIVATE_KEY_PASSWORDS)

    def get_prep_value(self, value):
        value = super(EncryptedPrivateKeyField, self).get_prep_value(value)
        if value is None:
            return None

        return force_text(self.cryptographer.encrypt(value))

    def from_db_value(self, value, expression, connection, context):
        if value is None:
            return None

        decrypted_key = self.cryptographer.decrypt(value)
        return force_bytes(self.to_python(decrypted_key))
