""" Теперь не нужно, можно удалить. Используется только для того, что бы не отправлять письма о
истекающих сертификатах людям, которые их уже перезапросили и установили
"""


import logging

from django.utils import timezone

from intranet.crt.core.utils import shell_exec
from intranet.crt.core.models import Certificate
from intranet.crt.constants import CERT_TYPE, CERT_STATUS
from intranet.crt.utils.base_command import BaseCommand
from intranet.crt.utils.ssl import PemCertificate

log = logging.getLogger(__name__)


def get_ssl_certificate(host, port):
    """Коннектится к указанному серверу, берет оттуда ssl сертификат и возвращает его в виде текста.
    В случае таймаута или невозможности установить ssl соединение, возвращает None."""

    command = 'timeout 3 openssl s_client -connect {host}:{port}'
    response = shell_exec(command, host=host.encode('idna'), port=port)

    certificate = []

    for line in response.std_out.split('\n'):
        if line == '-----BEGIN CERTIFICATE-----' or certificate:
            certificate.append(line)
        if line == '-----END CERTIFICATE-----':
            return '\n'.join(certificate)


def get_serial(hostname):
    if hostname.startswith('*'):
        return

    certificate = get_ssl_certificate(hostname, 443)
    if certificate:
        return PemCertificate(certificate).serial_number


def check_if_deployed(cert):
    hosts = [host.hostname for host in cert.hosts.all()]

    serials = list(map(get_serial, hosts))
    if cert.serial_number in serials:
        return True

    # если в списке получаенных серийников есть None,
    # то значит что на каком-то из проверяемых хостов
    # либо недоступен 443 порт, либо еще какая-то беда
    # приключилась, и невозможно установить ssl соединение
    if None not in serials:
        return False

    return None


class Command(BaseCommand):
    help = """Проверяет, что SSL сертификаты установлены на соответствующие хосты."""
    # TODO(lavrukov): Узнать у безопасников, нужно ли это вообще

    def _handle(self, *args, **options):
        certs = Certificate.objects.filter(type__name=CERT_TYPE.HOST, status=CERT_STATUS.ISSUED)

        if args:
            certs = certs.filter(pk__in=args)

        for cert in certs:
            try:
                self._check(cert)
            except:
                log.exception('Unable to check if cert {} deployed'.format(cert.id))

    def _check(self, cert):
        deployed = check_if_deployed(cert)
        queryset = Certificate.objects.filter(pk=cert.id)

        if deployed and not cert.deployed_at:
            queryset.update(deployed_at=timezone.now())
            log.info('Certificate %s is deployed', cert.id)

        elif deployed is not None and not deployed and cert.deployed_at:
            queryset.update(deployed_at=None)
            log.info('Certificate %s is undeployed', cert.id)

        elif deployed is None:
            queryset.update(deployed_at=None)
