from django.utils import timezone

from intranet.crt.core.models import AliveCheckpoint
from intranet.crt.utils.base_command import BaseCommand


class Command(BaseCommand):
    def _handle(self, *args, **options):
        checkpoint, _ = AliveCheckpoint.objects.get_or_create()
        checkpoint.modified_at = timezone.now()
        checkpoint.save(update_fields=['modified_at'])
