# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.db.models import Prefetch
from django.db import transaction

from intranet.crt.actions.models import Action, ACTION_TYPE
from intranet.crt.api.v1.certificates.serializers.specified import HypercubeCertSerializer
from intranet.crt.constants import CERT_TYPE
from intranet.crt.core.models import Certificate, CrtUser
from intranet.crt.utils.base_command import BaseCommand


class Command(BaseCommand):
    def _handle(self, *args, **options):
        hypercube_certs = Certificate.objects.filter(type__name=CERT_TYPE.HYPERCUBE)
        count = hypercube_certs.count()
        users_pks = {u.username: u.pk for u in CrtUser.objects.only('username', 'pk')}
        common_names = set(hypercube_certs.values_list('common_name', flat=True).distinct())

        def get_username_from_common_name(common_name):
            match = HypercubeCertSerializer.common_name_pattern.match(common_name)

            if match is None:
                raise Exception('Invalid common name: {}'.format(common_name))

            return match.group(1)

        updated = 0
        for common_name in common_names:
            username = get_username_from_common_name(common_name)
            updated += hypercube_certs.filter(common_name=common_name).update(user_id=users_pks[username])
            print('updated: {}/{}'.format(updated, count))
