from django.db.models import Prefetch
from django.db import transaction

from intranet.crt.actions.models import Action, ACTION_TYPE
from intranet.crt.core.models import Certificate
from intranet.crt.utils.base_command import BaseCommand


class Command(BaseCommand):
    def _handle(self, *args, **options):
        params = (
            (ACTION_TYPE.CERT_REVOKE, 'revoked_by_id'),
            (ACTION_TYPE.CERT_HOLD, 'held_by_id'),
            (ACTION_TYPE.CERT_UNHOLD, 'unheld_by_id')
        )
        pk = 0
        limit = 1000

        for action_type, field_name in params:
            certificates = (
                Certificate.objects
                .filter(
                    actions__isnull=False,
                )
                .prefetch_related(
                    Prefetch('actions', queryset=Action.objects.filter(type=action_type).order_by('-added'))
                )
                .order_by('pk')
            )

            while True:
                batch = certificates.filter(pk__gt=pk)[:limit]
                with transaction.atomic():
                    for cert in batch:
                        last_action = cert.actions.first()
                        if last_action is not None:
                            setattr(cert, field_name, last_action.user_id)
                            cert.save(update_fields=[field_name])

                try:
                    pk = batch[limit - 1].pk
                except IndexError:
                    break
