from intranet.crt.constants import CERT_TYPE
from intranet.crt.core.models import Certificate, Host
from intranet.crt.utils.base_command import BaseCommand


class Command(BaseCommand):
    def _handle(self, *args, **options):
        yc_servers = Certificate.objects.filter(type__name=CERT_TYPE.YC_SERVER, hosts__id=None)
        for cert in yc_servers:
            host, _ = Host.objects.get_or_create(hostname=cert.common_name)
            cert.hosts.add(host)

