from intranet.crt.core.controllers.certificates import HostCertificateController
from intranet.crt.utils.base_command import BaseCommand


class Command(BaseCommand):
    help = """Рассылает письма об истекающих сертификатах"""
    options = ['nearby_days']

    def add_arguments(self, parser):
        parser.add_argument(
            '--nearby-days',
            action='store_true',
            dest='nearby_days',
            help='Сообщить только о сертификатах, истекающих в ближайшие дни',
            default=False,
        )

    def _handle(self, *args, **options):
        nearby_days = options.get('nearby_days', False)
        HostCertificateController.expiring_host_certs_notify(nearby_days)
