import logging

import waffle
from django.db.models import Q

from intranet.crt.core.models import Certificate
from intranet.crt.constants import CERT_STATUS, CERT_TYPE
from intranet.crt.core.ca import get_async_ca_names
from intranet.crt.utils.base_command import BaseCommand


class Command(BaseCommand):
    help = """Выписывает запрошенные сертификаты"""

    def _handle(self, *args, **options):
        q_certificate_type = Q()

        if waffle.switch_is_active('client_server_should_be_approved'):
            q_certificate_type |= Q(type__name=CERT_TYPE.CLIENT_SERVER)
        if waffle.switch_is_active('bank_client_server_should_be_approved'):
            q_certificate_type |= Q(type__name=CERT_TYPE.BANK_CLIENT_SERVER)

        client_server_certs = (
            Certificate.objects
            .filter(
                Q(ca_name__in=get_async_ca_names()) | q_certificate_type,
                status__in=(CERT_STATUS.REQUESTED, CERT_STATUS.VALIDATION),
            )
        )
        for cert in client_server_certs:
            try:
                cert.controller.issue()
            except Exception:
                logging.exception('Can not issue certificate {}'.format(cert.id))
