import yaml
import tempfile
from datasources_config_wrapper import DatasourcesConfigWrapper
from django_pgaas import HostManager
import intranet.crt.settings
from intranet.crt.utils import pgaas
from intranet.crt.utils.base_command import BaseCommand


class Action(object):
    Show = 0
    Do = 1

class Command(BaseCommand):

    help = "Запускает переливание из mysql в pgsql"

    options = ['mode']

    def add_arguments(self, parser):
        parser.add_argument(
            '--mode',
            dest='mode',
            help='"do" - запустить переливку, "show" - посмотреть параметры запуска',
            default='show',
        )


    def get_pg_src(self):
        manager = HostManager.create_from_yc(crt.settings.ds.pg_hosts)
        return pgaas.create_profile(manager, crt.settings.ds, 'read-write')

    def _handle(self, *args, **options):
        mode = options['mode']
        action = Action.Show
        if mode == 'do':
            action = Action.Do

        if action == Action.Do:
            import mysql2pgsql

        config = DatasourcesConfigWrapper(prefix='crt')

        mysql = {
            'database': config.database_db,
            'username': config.database_user,
            'hostname': config.database_host_master,
            'port': int(config.database_port_master),
            'password': config.database_password,
            'compress': False
        }

        pg_src = self.get_pg_src()

        pg = {
            'database': pg_src['NAME'],
            'username': pg_src['USER'],
            'hostname': pg_src['HOST'],
            'port': int(pg_src['PORT']),
            'password': pg_src['PASSWORD']
        }

        config = {
            'mysql': mysql,
            'destination': {'postgres': pg, 'file': None},
            'supress_data': False,
            'supress_ddl': False,
            'force_truncate': False,
            'timezone': False
        }

        with tempfile.NamedTemporaryFile('wt') as conffile:
            yaml.dump(config, conffile, default_flow_style=False)

            if action == Action.Do:
                class Args(object):
                    file = conffile.name
                    verbose = True

                converter = mysql2pgsql.Mysql2Pgsql(Args)
                converter.convert()
            else:
                print(('>>> %s <<<' % conffile.name))
                print((open(conffile.name, 'rt').read()))

