import logging

from django.utils.deprecation import MiddlewareMixin
from django_replicated.middleware import ReplicationMiddleware, ReadOnlyMiddleware
from intranet.crt import VERSION
from intranet.crt.utils.replication import is_in_manual_read_only

log = logging.getLogger(__name__)


class CrtReplicationMiddleware(ReplicationMiddleware):
    """Отличается от базовой только возможностью вручную включить режим read_only,
    для чего используется свойство forced_state"""

    def process_request(self, request):
        self.forced_state = None
        readonly_flag = is_in_manual_read_only()
        if readonly_flag:
            self.forced_state = 'slave'
        return super(CrtReplicationMiddleware, self).process_request(request)


class CrtReadOnlyMiddleware(ReadOnlyMiddleware):
    """
    При отвалившемся мастере выставляем флаг read_only и переводим
    все запросы на слейв
    """

    def is_service_read_only(self):
        is_read_only = super(CrtReadOnlyMiddleware, self).is_service_read_only()
        is_manual_read_only = False
        if is_read_only:
            log.info('Service is in automatic read-only')
        else:
            is_manual_read_only = is_in_manual_read_only()
            if is_manual_read_only:
                log.info('Service is in manual read-only')
        return is_read_only or is_manual_read_only


class InfoHeadersMiddleware(MiddlewareMixin):
    def process_response(self, request, response):
        response['X-CRT-READONLY'] = str(request.service_is_readonly).lower()
        response['X-CRT-VERSION'] = VERSION
        return response
