from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Action',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('type', models.CharField(max_length=20, choices=[(b'revoke', b'Revoke'), (b'deploy', b'Deploy'), (b'undeploy', b'Undeploy')])),
                ('added', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='AliveCheckpoint',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('modified_at', models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name='ApproveRequest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('create_date', models.DateTimeField(auto_now_add=True)),
                ('approved', models.BooleanField(default=False)),
                ('update_date', models.DateTimeField(auto_now=True)),
                ('approver', models.ForeignKey(related_name='approve_requests', default=None, to=settings.AUTH_USER_MODEL, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Certificate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('status', models.CharField(default=b'requested', max_length=20, choices=[(b'requested', b'\xd0\x97\xd0\xb0\xd0\xbf\xd1\x80\xd0\xbe\xd1\x88\xd0\xb5\xd0\xbd'), (b'validation', b'\xd0\x9e\xd0\xb6\xd0\xb8\xd0\xb4\xd0\xb0\xd0\xb5\xd1\x82 \xd0\xbf\xd0\xbe\xd0\xb4\xd1\x82\xd0\xb2\xd0\xb5\xd1\x80\xd0\xb6\xd0\xb4\xd0\xb5\xd0\xbd\xd0\xb8\xd1\x8f'), (b'issued', b'\xd0\x92\xd1\x8b\xd0\xb4\xd0\xb0\xd0\xbd'), (b'revoked', b'\xd0\x9e\xd1\x82\xd0\xbe\xd0\xb7\xd0\xb2\xd0\xb0\xd0\xbd'), (b'hold', b'\xd0\x97\xd0\xb0\xd0\xbc\xd0\xbe\xd1\x80\xd0\xbe\xd0\xb6\xd0\xb5\xd0\xbd'), (b'error', b'\xd0\x9f\xd1\x80\xd0\xbe\xd0\xb8\xd0\xb7\xd0\xbe\xd1\x88\xd0\xbb\xd0\xb0 \xd0\xbe\xd1\x88\xd0\xb8\xd0\xb1\xd0\xba\xd0\xb0'), (b'expired', b'\xd0\x98\xd1\x81\xd1\x82\xd0\xb5\xd0\xba'), (b'revoking', b'\xd0\x92 \xd0\xbf\xd1\x80\xd0\xbe\xd1\x86\xd0\xb5\xd1\x81\xd1\x81\xd0\xb5 \xd0\xbe\xd1\x82\xd0\xb7\xd1\x8b\xd0\xb2\xd0\xb0'), (b'need_approve', b'\xd0\xa2\xd1\x80\xd0\xb5\xd0\xb1\xd1\x83\xd0\xb5\xd1\x82 \xd0\xbf\xd0\xbe\xd0\xb4\xd1\x82\xd0\xb2\xd0\xb5\xd1\x80\xd0\xb6\xd0\xb4\xd0\xb5\xd0\xbd\xd0\xb8\xd0\xb5'), (b'rejected', b'\xd0\x9e\xd1\x82\xd0\xba\xd0\xbb\xd0\xbe\xd0\xbd\xd0\xb5\xd0\xbd')])),
                ('ca_name', models.CharField(max_length=30, choices=[(b'InternalCA', b'\xd0\x92\xd0\xbd\xd1\x83\xd1\x82\xd1\x80\xd0\xb5\xd0\xbd\xd0\xbd\xd0\xb8\xd0\xb9 CA'), (b'RcInternalCA', b'Subordinate enterprise CA \xd0\xb4\xd0\xbb\xd1\x8f \xd0\xbd\xd1\x83\xd0\xb6\xd0\xb4 runtime cloud'), (b'CertumProductionCA', b'Certum (production)'), (b'GlobalSignProductionCA', b'GlobalSign (production)'), (b'TestCA', b'Self-signed'), (b'InternalTestCA', b'\xd0\x92\xd0\xbd\xd1\x83\xd1\x82\xd1\x80\xd0\xb5\xd0\xbd\xd0\xbd\xd0\xb8\xd0\xb9 \xd1\x82\xd0\xb5\xd1\x81\xd1\x82\xd0\xbe\xd0\xb2\xd1\x8b\xd0\xb9 CA'), (b'CertumTestCA', b'Certum (testing, defunct)'), (b'GlobalSignTestCA', b'GlobalSign  (testing)')])),
                ('serial_number', models.CharField(max_length=64, null=True, blank=True)),
                ('added', models.DateTimeField(auto_now_add=True)),
                ('end_date', models.DateTimeField(null=True, editable=False, blank=True)),
                ('certificate', models.TextField(null=True, blank=True)),
                ('request', models.TextField(help_text=b'\xd0\x94\xd0\xbb\xd1\x8f pc, linux-pc \xd0\xb8 linux-token \xd1\x81\xd0\xb5\xd1\x80\xd1\x82\xd0\xb8\xd1\x84\xd0\xb8\xd0\xba\xd0\xb0\xd1\x82\xd0\xbe\xd0\xb2 CSR \xd0\xb3\xd0\xb5\xd0\xbd\xd0\xb5\xd1\x80\xd1\x8f\xd1\x82\xd1\x81\xd1\x8f \xd1\x85\xd0\xb5\xd0\xbb\xd0\xbf\xd0\xb0\xd0\xbc\xd0\xb8.', null=True, blank=True)),
                ('common_name', models.CharField(max_length=100, null=True, blank=True)),
                ('revoke_at', models.DateTimeField(null=True, blank=True)),
                ('request_id', models.CharField(max_length=100, null=True, blank=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('issued', models.DateTimeField(null=True, blank=True)),
                ('revoked', models.DateTimeField(null=True, blank=True)),
                ('email', models.CharField(max_length=100, null=True, blank=True)),
                ('old_hosts', models.TextField(null=True, blank=True)),
                ('pc_hostname', models.CharField(max_length=100, null=True, blank=True)),
                ('pc_os', models.CharField(max_length=100, null=True, blank=True)),
                ('pc_serial_number', models.CharField(max_length=100, null=True, blank=True)),
                ('pc_mac', models.CharField(help_text='Mac \u0430\u0434\u0440\u0435\u0441\u0430, \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0435 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e.', max_length=1000, null=True, blank=True)),
                ('pc_inum', models.CharField(help_text='\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440', max_length=100, null=True, blank=True)),
                ('hosts_count', models.IntegerField(default=0)),
                ('wildcards_count', models.IntegerField(default=0)),
                ('extended_validation', models.BooleanField(default=False)),
                ('deployed_at', models.DateTimeField(help_text='\u0414\u0430\u0442\u0430, \u043a\u043e\u0433\u0434\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u044b\u044f\u0432\u0438\u043b\u0430, \u0447\u0442\u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0445\u043e\u0442\u044f \u0431\u044b \u043d\u0430 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0445 \u0445\u043e\u0441\u0442\u043e\u0432', null=True, blank=True)),
                ('expiration_notified_at', models.DateTimeField(help_text='\u0412\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u0438\u0441\u044c\u043c\u0430 \u043e \u0442\u043e\u043c, \u0447\u0442\u043e \u0441\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0441\u043a\u043e\u0440\u043e \u0438\u0441\u0442\u0435\u043a\u0430\u0435\u0442.', null=True, blank=True)),
                ('unable_to_check_if_deployed', models.BooleanField(default=False)),
                ('used_template', models.CharField(help_text='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0431\u044b\u043b \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0432\u043e \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u043c CA.', max_length=100, null=True, blank=True)),
                ('priv_key_deleted_at', models.DateTimeField(help_text='\u0414\u0430\u0442\u0430, \u043a\u043e\u0433\u0434\u0430 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d \u043f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447', null=True, blank=True)),
                ('error_message', models.CharField(help_text='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435, \u0435\u0441\u043b\u0438 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0431\u044b\u043b \u043f\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043d \u0432 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 error.', max_length=8192, null=True, blank=True)),
                ('has_problems', models.BooleanField(default=False, help_text='\u0415\u0441\u043b\u0438 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u043e\u0439 check_problems \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043a\u0430\u043a\u0438\u0435-\u0442\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b, \u0442\u043e True.')),
                ('device_platform', models.CharField(max_length=100, null=True, blank=True)),
                ('device_subclass', models.CharField(max_length=100, null=True, blank=True)),
            ],
            options={
                'permissions': (('can_use_console', 'Can use console'), ('can_issue_globalsign', 'Can issue globalsign certificates'), ('can_revoke_any_certificate', 'Can revoke any certificate'), ('can_issue_device_certificates', 'Can issue certificates for macs, pcs and tokens'), ('can_issue_ev_certificates', 'Can issue EV certificates'), ('can_issue_without_approve', 'Can issue certificate without security approve'), ('can_issue_rc_server_certificates', 'Can issue rc-server certificates'), ('can_issue_client_server_certificates', 'Can issue client-server certificates'), ('is_responsible_for_any_host', 'Responsible for any host')),
            },
        ),
        migrations.CreateModel(
            name='CertificateHost',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
        ),
        migrations.CreateModel(
            name='CertificateProblem',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('type', models.CharField(max_length=20, choices=[(b'duplicate', b'Duplicate')])),
                ('discovered', models.DateTimeField(auto_now_add=True)),
                ('gone', models.DateTimeField(null=True, blank=True)),
                ('description', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='CertificateType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(unique=True, max_length=16)),
                ('is_active', models.BooleanField(default=True)),
                ('description', models.CharField(max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='Host',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('hostname', models.CharField(unique=True, max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='HostToApprove',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('host', models.CharField(unique=True, max_length=100)),
                ('code', models.CharField(default=None, max_length=32, null=True, blank=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('expire_at', models.DateTimeField(default=None, null=True, blank=True)),
                ('validated', models.BooleanField(default=False)),
                ('name_servers', models.CharField(max_length=1024, null=True, blank=True)),
                ('managed_dns', models.BooleanField(default=False, help_text='\u0421\u0435\u0440\u0432\u0435\u0440\u0430 \u043f\u043e\u0434 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041e\u043b\u0435\u0433\u0430 \u0413\u043e\u0440\u043e\u0445\u043e\u0432\u0430')),
                ('auto_managed', models.BooleanField(default=False, help_text='\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u0434\u043e\u043c\u0435\u043d\u0430 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0430')),
                ('globalsign_domain_id', models.CharField(max_length=20, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='HostToApproveHistory',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('action', models.CharField(max_length=40)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('validation_code', models.CharField(max_length=40, null=True, blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='ImapCheckerLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('num_letters', models.IntegerField()),
                ('num_hosts_to_approve', models.IntegerField()),
                ('maximum_uid', models.IntegerField()),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='PrivateKey',
            fields=[
                ('certificate', models.OneToOneField(related_name='private_key', primary_key=True, serialize=False, to='core.Certificate')),
                ('data', models.TextField()),
            ],
        ),
        migrations.AddField(
            model_name='hosttoapprovehistory',
            name='certificate',
            field=models.ForeignKey(related_name='host_actions', blank=True, to='core.Certificate', null=True),
        ),
        migrations.AddField(
            model_name='hosttoapprovehistory',
            name='host',
            field=models.ForeignKey(related_name='history', to='core.HostToApprove'),
        ),
        migrations.AddField(
            model_name='hosttoapprove',
            name='certificates',
            field=models.ManyToManyField(related_name='hosts_to_approve', to='core.Certificate', blank=True),
        ),
        migrations.AddField(
            model_name='host',
            name='certificates',
            field=models.ManyToManyField(related_name='hosts', through='core.CertificateHost', to='core.Certificate'),
        ),
        migrations.AddField(
            model_name='certificateproblem',
            name='certificate',
            field=models.ForeignKey(related_name='problems', to='core.Certificate'),
        ),
        migrations.AddField(
            model_name='certificateproblem',
            name='related_certificate',
            field=models.ForeignKey(related_name='related_problems', blank=True, to='core.Certificate', null=True),
        ),
        migrations.AddField(
            model_name='certificatehost',
            name='certificate',
            field=models.ForeignKey(to='core.Certificate'),
        ),
        migrations.AddField(
            model_name='certificatehost',
            name='host',
            field=models.ForeignKey(to='core.Host'),
        ),
        migrations.AddField(
            model_name='certificate',
            name='requester',
            field=models.ForeignKey(related_name='requested_certificates', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='certificate',
            name='type',
            field=models.ForeignKey(related_name='certificates', to='core.CertificateType'),
        ),
        migrations.AddField(
            model_name='certificate',
            name='user',
            field=models.ForeignKey(related_name='certificates', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='approverequest',
            name='certificate',
            field=models.OneToOneField(related_name='approve_request', to='core.Certificate'),
        ),
        migrations.AddField(
            model_name='action',
            name='certificate',
            field=models.ForeignKey(related_name='actions', to='core.Certificate'),
        ),
        migrations.AddField(
            model_name='action',
            name='user',
            field=models.ForeignKey(related_name='actions', to=settings.AUTH_USER_MODEL),
        ),
    ]
