from django.db import migrations, models
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.AlterField(
            model_name='action',
            name='certificate',
            field=models.ForeignKey(related_name='actions', on_delete=django.db.models.deletion.PROTECT, to='core.Certificate'),
        ),
        migrations.AlterField(
            model_name='action',
            name='type',
            field=models.CharField(max_length=20, choices=[(b'revoke', b'Revoke'), (b'hold', b'Hold'), (b'deploy', b'Deploy'), (b'undeploy', b'Undeploy')]),
        ),
        migrations.AlterField(
            model_name='action',
            name='user',
            field=models.ForeignKey(related_name='actions', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='approverequest',
            name='approver',
            field=models.ForeignKey(related_name='approve_requests', on_delete=django.db.models.deletion.PROTECT, default=None, to=settings.AUTH_USER_MODEL, null=True),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='deployed_at',
            field=models.DateTimeField(null=True, blank=True),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='requester',
            field=models.ForeignKey(related_name='requested_certificates', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='type',
            field=models.ForeignKey(related_name='certificates', on_delete=django.db.models.deletion.PROTECT, to='core.CertificateType'),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='user',
            field=models.ForeignKey(related_name='certificates', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL),
        ),
    ]
