from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0009_certificate_desired_ttl_days'),
    ]

    operations = [
        migrations.CreateModel(
            name='TaskTimestamp',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('type', models.CharField(max_length=15, choices=[
                    ('sync_tags', 'Tags'),
                    ('sync_users', 'Sync users'),
                    ('upload_tags_to_cvs', 'Upload tags to cvs'),
                ])),
                ('start', models.DateTimeField(auto_now_add=True)),
                ('finish', models.DateTimeField(null=True, blank=True)),
                ('is_success', models.BooleanField(default=False)),
                ('traceback', models.TextField(null=True, blank=True)),
            ],
        ),
        migrations.AlterField(
            model_name='certificate',
            name='added',
            field=models.DateTimeField(auto_now_add=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='request',
            field=models.TextField(help_text='\u0414\u043b\u044f pc, linux-pc \u0438 linux-token \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432 CSR \u0433\u0435\u043d\u0435\u0440\u044f\u0442\u0441\u044f \u0445\u0435\u043b\u043f\u0430\u043c\u0438.', null=True, blank=True),
        ),
    ]
