from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0017_add_permissions'),
    ]

    operations = [
        migrations.RunSQL(
            '''
                alter table core_privatekey
                drop foreign key certificate_id_refs_id_5f3c981675f31d1
            '''
        ),
        migrations.RunSQL(
            '''
                alter table core_privatekey drop primary key
            '''
        ),
        migrations.RunSQL(
            '''
                alter table core_privatekey add id int
                not null primary key auto_increment
                after certificate_id
            '''
        ),
        migrations.RunSQL(
            '''
                alter table core_certificate
                add column private_key_id integer null
            '''
        ),
        migrations.RunSQL(
            '''
                alter table core_certificate
                add constraint private_key_fk
                foreign key (private_key_id)
                references core_privatekey (id)
            '''
        ),
        migrations.RunSQL(
            '''
                update core_certificate as c, core_privatekey as p
                set c.private_key_id = p.id
                where c.id = p.certificate_id
            '''
        ),
        migrations.RunSQL(
            '''
                alter table core_privatekey
                drop column certificate_id
            '''
        ),
    ]
