from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    """ Фейковая миграция для закрепления состояния после применения предыдущей """

    dependencies = [
        ('core', '0018_reverse_private_key_relation'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='privatekey',
            name='certificate',
        ),
        migrations.AddField(
            model_name='certificate',
            name='private_key',
            field=models.OneToOneField(related_name='certificate', null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.PrivateKey'),
        ),
        migrations.AddField(
            model_name='privatekey',
            name='id',
            field=models.AutoField(auto_created=True, primary_key=True, default=1, serialize=False, verbose_name='ID'),
            preserve_default=False,
        ),
    ]
