from django.db import migrations, models
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0023_add_abc_service_field'),
    ]

    operations = [
        migrations.AddField(
            model_name='certificate',
            name='is_imported',
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='error_message',
            field=models.CharField(max_length=8192, null=True, blank=True),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='expiration_notified_at',
            field=models.DateTimeField(help_text='\u0412\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043f\u0438\u0441\u044c\u043c\u0430 \u043e \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u0438 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430', null=True, blank=True),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='user',
            field=models.ForeignKey(related_name='certificates', on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, null=True),
        ),
        migrations.AlterField(
            model_name='tasktimestamp',
            name='type',
            field=models.CharField(max_length=31, choices=[('sync_abc_services', 'Sync ABC services'), ('sync_assessor_certs', 'Sync assessor certs'), ('sync_tags', 'Sync tags'), ('sync_users', 'Sync users'), ('sync_certs_internal_ca', 'Sync InternalCA certs'), ('cvs_tags_upload', 'Upload tags to cvs')]),
        ),
    ]
