from django.db import migrations


CREATE_TABLE_SQL = '''
CREATE TABLE core_host_certificates (
  id int(11) NOT NULL AUTO_INCREMENT,
  certificate_id int(11) NOT NULL,
  host_id int(11) NOT NULL,
  PRIMARY KEY (id),
  CONSTRAINT certificate_id_refs_id_custom FOREIGN KEY (certificate_id) REFERENCES core_certificate (id),
  CONSTRAINT host_id_refs_id_custom FOREIGN KEY (host_id) REFERENCES core_host (id)
)
'''


class Migration(migrations.Migration):
    dependencies = [
        ('core', '0028_add_ca_name_serial_number_unique_index'),
    ]

    operations = [
        migrations.RunSQL(CREATE_TABLE_SQL),
        migrations.RunSQL('create unique index unique_host_cert on core_host_certificates (host_id, certificate_id)'),
        migrations.RunSQL('insert ignore core_host_certificates select * from core_certificatehost'),
        migrations.RunSQL('drop table core_certificatehost'),
    ]
