# Generated by Django 1.11.11 on 2018-06-07 20:42


from django.conf import settings
from django.db import migrations

import intranet.crt.core.fields
from intranet.crt.utils.ssl import PrivateKeyCryptographer


def encrypt_private_keys(apps, schema_editor):
    cryptographer = PrivateKeyCryptographer(settings.CRT_PRIVATE_KEY_PASSWORDS)

    private_key_cls = apps.get_model('core', 'PrivateKey')
    for private_key in private_key_cls.objects.all():
        private_key.data = cryptographer.encrypt(private_key.data)
        private_key.save()


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0034_expand_hostname_commonname_length'),
    ]

    operations = [
        migrations.RunPython(encrypt_private_keys),
        migrations.AlterField(
            model_name='privatekey',
            name='data',
            field=intranet.crt.core.fields.EncryptedPrivateKeyField(),
        ),
    ]
