# Generated by Django 1.11.26 on 2019-11-14 13:30


from django.db import migrations, models


def add_new_permission(apps, schema_editor):
    Permission = apps.get_model('auth', 'Permission')
    ContentType = apps.get_model('contenttypes', 'ContentType')
    Group = apps.get_model('auth', 'Group')
    content_type = ContentType.objects.get(model='certificate', app_label='core')
    new_permission = Permission.objects.create(
        codename='can_revoke_users_certificates',
        name='Can revoke users certificates',
        content_type=content_type,
    )
    old_permission = Permission.objects.get(codename='can_revoke_any_certificate')
    helpdesk_group = Group.objects.get(name='Helpdesk')
    helpdesk_group.permissions.add(new_permission)
    helpdesk_group.permissions.remove(old_permission)


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0045_certificate_st_id'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='certificate',
            options={'permissions': (('can_use_console', 'Can use console'), ('can_issue_globalsign', 'Can issue globalsign certificates'), ('can_issue_cb_internal_ca', 'Can issue certificates on CbInternalCA'), ('can_revoke_any_certificate', 'Can revoke any certificate'), ('can_issue_device_certificates', 'Can issue certificates for macs, pcs and tokens'), ('can_issue_ev_certificates', 'Can issue EV certificates'), ('can_issue_without_approve', 'Can issue certificate without security approve'), ('can_issue_rc_server_certificates', 'Can issue rc-server certificates'), ('can_issue_yc_server_certificates', 'Can issue yc-server certificates'), ('can_issue_zomb_pc_certificates', 'Can issue zomb-pc certificates'), ('can_issue_hypercube_certificates', 'Can issue hypercube certificates'), ('can_issue_client_server_certificates', 'Can issue client-server certificates'), ('can_issue_sdc_certificates', 'Can issue sdc certificates'), ('is_responsible_for_any_host', 'Responsible for any host'), ('can_have_assessor_certificate', 'Can get an assessor certificate'), ('can_issue_imdm_certificates', 'Can issue imdm certificates'), ('can_change_abc_service_for_any_certificate', 'Can change ABC service for any certificate'), ('can_view_any_certificate', 'Can view any certificate'), ('can_download_any_certificate', 'Can download any certificate'), ('can_revoke_users_certificates', 'Can revoke users certificates'))},
        ),
        migrations.AlterField(
            model_name='certificate',
            name='hardware_request_st_id',
            field=models.TextField(help_text='\u041a\u043b\u044e\u0447 \u0442\u0438\u043a\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0442\u0430\u0447\u043a\u0438', null=True),
        ),
        migrations.RunPython(add_new_permission),
    ]
