import logging

from django.core.mail import EmailMessage
from django.template.loader import render_to_string
from django.conf import settings

from intranet.crt.users.models import CrtUser


log = logging.getLogger(__name__)


def notify(email_or_emails, message_type, attachments=None, cc_emails=None, **kwargs):
    from_email = CrtUser.objects.robot_crt.email

    if isinstance(email_or_emails, str):
        email_or_emails = [email_or_emails]

    subject = kwargs.get('subject', 'Без темы')
    context = {'settings': settings}
    context.update(kwargs)

    content = render_to_string('emails/{0}.html'.format(message_type), context)

    if settings.CRT_TEST_NOTIFICATIONS:
        subject += ' ({})'.format(', '.join(email_or_emails))
        email_or_emails = [settings.CRT_NOTIFICATIONS_TEST_BCC]
        cc_emails = None

    msg = EmailMessage(subject, content, from_email, to=email_or_emails, cc=cc_emails)
    msg.content_subtype = 'html'
    msg.extra_headers['Reply-To'] = 'devnull@yandex-team.ru'

    if attachments is not None:
        for attachment in attachments:
            msg.attach(attachment['filename'], attachment['content'], attachment['mimetype'])

    msg.send()
    log.info('Sent notification email to %s:  %s', ', '.join(msg.to), msg.subject)
