var console_app = angular.module('console_app', ['ngRoute']);

console_app.config(['$routeProvider', '$locationProvider',
                    function($routeProvider, $locationProvider) {
                        $locationProvider.hashPrefix('!');

                        $routeProvider.
                            when('/',
                                 {controller: 'SearchCtrl',
                                  templateUrl: '/static/search.html',
                                  reloadOnSearch: false}).
                            when('/certificate/:id',
                                 {controller: 'CertificateCtrl',
                                  templateUrl: '/static/certificate.html'}).
                            when('/domains',
                                 {controller: 'DomainsCtrl',
                                  templateUrl: '/static/domains.html'}).
                            when('/domain/:id',
                                 {controller: 'DomainCtrl',
                                  templateUrl: '/static/domain.html'}).


                        otherwise({redirectTo:'/'});
                    }]);


var make_date_from_now2 = function() {
    var args = Array.prototype.slice.call(arguments);
    return function (item) {
        args.forEach(function(field) {
            var dt = item[field];
            if (dt !== null) {
                item[field + '_from_now'] = moment(dt).lang('ru').fromNow();
                item[field] = moment(dt).lang('ru').format('YYYY-MM-DD HH:mm:ss ZZ');
            }
        });
        return item;
    }
}



console_app.controller(
    'SearchCtrl2',
    ['$scope', '$http', '$log', '$timeout', '$location',
     function ($scope, $http, $log, $timeout, $location) {
         $scope.page_size = 50;
         $scope.results = [];
         // a counter to count how many results were loaded
         $scope.loaded = 0;
         $scope.query = $location.search().query || '';

         var load_data = function (url) {
             $http.get(url).success(function(data) {
                 // insert an object's id into each result item
                 if (data.results !== undefined) {
                     for (i = 0; i < data.results.length; i++) {
                         var result = data.results[i];
                         result.id = /(\d+)\/$/.exec(result.url)[1];
                     }

                     data.results.forEach(make_date_from_now('added'));
                     $scope.results = $scope.results.concat(data.results);

                     $scope.has_results = $scope.results.length > 0;
                     $scope.loaded += data.results.length;
                     $scope.more_url = data.next;
                     $scope.more_count = data.count - $scope.loaded;

                     $scope.pre_last_page = $scope.more_count <= $scope.page_size;
                 }
             });
         }

         var submit_timer;

         $scope.submit = function () {
             // надо отменить запланированное обновление, чтобы
             // результаты поиска не мигали дважды в случае
             // если submit вызван нажатием Enter
             $timeout.cancel(submit_timer);

             var params = $location.search();
             params.query = $scope.query;
             $location.search(params);

             $scope.loaded = 0;
             $scope.results = [];
             load_data('/api/certificate/?query=' + $scope.query + '&page_size=' + $scope.page_size);
         }

         $scope.schedule_submit = function () {
             $timeout.cancel(submit_timer);
             submit_timer = $timeout($scope.submit, 1000);
         }

         $scope.more = function () {
             load_data($scope.more_url);
         }

         $scope.submit();
     }]);


console_app.controller(
    'CertificateCtrl2',
    ['$scope', '$http', '$routeParams',
     function ($scope, $http, $routeParams) {
         $http.get('/api/permissions/').success(function(data) {
             $scope.perms = data;
         });
         $http.get('/api/certificate/' + $routeParams.id + '/').success(function(data) {
             make_date_from_now('added', 'end_date', 'revoked')(data);
             $scope.cert = data;

             var hosts = [];
             angular.forEach($scope.cert.hosts_to_approve, function (host) {
                 if (!host.validated) {
                     hosts.push(host.host);
                 }});

             if (hosts.length > 0) {
                 $scope.cert.waiting_for = 'ждем валидации: ' + hosts.join(', ');
             }
         });
         $scope.revoke = function() {
             $http.delete('/api/certificate/' + $routeParams.id).success(function(data) {
                 $scope.cert = data;
             });
         }
     }]);


console_app.controller(
    'DomainsCtrl2',
    ['$scope', '$http',
     function ($scope, $http) {
         $http.get('/api/hosts/to-approve/?all&fields=id,host,validated').success(function(data) {
             $scope.domains = data;
         });
     }]);


console_app.controller(
    'DomainCtrl2',
    ['$scope', '$http', '$routeParams',
     function ($scope, $http, $routeParams) {
         var format_dates = make_date_from_now('created', 'updated');

         $http.get('/api/hosts/to-approve/' + $routeParams.id + '/?fields=__all__').success(function(data) {
             format_dates(data);
             $scope.domain = data;
         });
         $http.get('/api/hosts/to-approve/' + $routeParams.id + '/history/').success(function(data) {
             data.forEach(format_dates);
             data.forEach(function(item) {
                 var match = /certificate\/\d+/.exec(item['certificate_uri']);
                 if (match != null) {
                     item['certificate_url'] = '#!/' + match[0];
                 }
             });
             $scope.history = data;
         });
     }]);
