(function() {
  function list() {
    var _i;
    var args = 1 <= arguments.length ? [].slice.call(arguments, 0, _i = arguments.length - 0) : (_i = 0, []);
    return [].concat(args);
  }

  function len(obj) {
    return obj.length;
  }
  len;

  function get_properties(obj) {
    var key, value, _res, _ref, _ref0;
    _res = [];
    _ref = obj;
    for (key in _ref) {
      value = _ref[key];
      if (typeof(_ref0 = list(key, value)) !== 'undefined') _res.push(_ref0);
    }
    return _res;
  }
  get_properties;

  function create_object(properties) {
    var obj, item, _i, _ref;
    obj = new Object();
    console.log(properties);
    _ref = properties;
    for (_i = 0; _i < _ref.length; ++_i) {
      item = _ref[_i];
      obj[item[0]] = item[1];
    }
    return obj;
  }
  create_object;

  function make_pairs(args) {
    var _res, _ref;
    _res = [];
    while (args.length > 0) {
      if (typeof(_ref = list(args.shift(), args.shift())) !== 'undefined') _res.push(_ref);
    }
    return _res;
  }
  make_pairs;

  function update(obj) {
    var _i;
    var new_properties = 2 <= arguments.length ? [].slice.call(arguments, 1, _i = arguments.length - 0) : (_i = 1, []);
    return create_object(list.apply(list, [].concat(get_properties(obj)).concat(make_pairs(new_properties))));
  }
  update;

  function make_date_from_now() {
    var _i;
    var fields = 1 <= arguments.length ? [].slice.call(arguments, 0, _i = arguments.length - 0) : (_i = 0, []);
    return (function(item) {
      var field, dt, _i0, _ref;
      _ref = fields;
      for (_i0 = 0; _i0 < _ref.length; ++_i0) {
        field = _ref[_i0];
        dt = item[field];
        if (dt) {
          item[field + "_from_now"] = moment.utc(dt)
            .lang("ru")
            .fromNow();
          item[field] = moment.utc(dt)
            .lang("ru")
            .local()
            .format("YYYY-MM-DD HH:mm:ss");
        }
      }
      return item;
    });
  }
  make_date_from_now;
  console_app.controller("SearchCtrl", list("$scope", "$http", "$log", "$timeout", "$location", (function($scope, $http, $log, $timeout, $location) {
    var location_search, load_data;
    $scope.page_size = 50;
    $scope.results = [];
    $scope.loaded = 0;
    location_search = $location.search();
    $scope.query = location_search.query || "";
    load_data = (function(url) {
      return $http["get"](url)
        .success((function(data) {
          var result, results, _i, _res, _ref, _ref0;
          if (data.results) {
            _res = [];
            _ref = data.results;
            for (_i = 0; _i < _ref.length; ++_i) {
              result = _ref[_i];
              result.id = /(\d+)\/$/.exec(result.url)["slice"](1)[0];
              make_date_from_now("added")(result);
              if (typeof result !== 'undefined') _res.push(result);
            }
            results = _res;
            $scope.results = $scope.results.concat(results);
            $scope.has_results = $scope.results.length > 0;
            $scope.loaded = $scope.loaded + len(data.results);
            $scope.more_url = data.next;
            $scope.more_count = data.count - $scope.loaded;
            _ref0 = ($scope.pre_last_page = $scope.more_count <= $scope.page_size);
          } else {
            _ref0 = undefined;
          }
          return _ref0;
        }));
    });
    $scope.more = (function() {
      return load_data($scope.more_url);
    });
    (function(submit_timer) {
      $scope.submit = (function() {
        var params;
        $timeout.cancel(submit_timer);
        params = $location.search();
        params.query = $scope.query;
        $location.search(params);
        $scope.loaded = 0;
        $scope.results = [];
        return load_data("/api/certificate/?query=" + $scope.query + "&page_size=" + $scope.page_size);
      });
      return ($scope.schedule_submit = (function() {
        $timeout.cancel(submit_timer);
        return (submit_timer = $timeout($scope.submit, 1000));
      }));
    })(null);
    return $scope.submit();
  })));


  console_app.controller("CertificateCtrl", list("$scope", "$http", "$routeParams", "$interpolate", "$sce", (function($scope, $http, $routeParams, $interpolate, $sce) {
    $http["get"]("/api/permissions/")
      .success((function(data) {
        return ($scope.perms = data);
      }));
    $http["get"]("/api/certificate/" + $routeParams.id + "/")
      .success((function(data) {
        var host, hosts, _i, _res, _ref, _ref0;
        make_date_from_now("added", "end_date", "revoked", "issued")(data);
        $scope.cert = data;
        $scope.revoking = false;
        $scope.revoking_error = undefined;
        $scope.approve_request = data.approve_request
        _res = [];
        _ref = $scope.cert.hosts_to_approve;
        for (_i = 0; _i < _ref.length; ++_i) {
          host = _ref[_i];
          if (typeof(_ref0 = (!host.validated ? host.host : undefined)) !== 'undefined') _res.push(_ref0);
        }
        hosts = _res;
        if (((data.status === "validation") && (hosts.length > 0))) $scope.cert.waiting_for = "ждем валидации: " + hosts.join(", ");
        if (data.status === "need_approve") $scope.cert.waiting_for = "ждем подтверждения СИБ";
        return (undefined);
      }));
    $scope.approve = (function(approved) {
      $scope.approving = true;
      $scope.approving_error = undefined;
      return $http["put"]("/api/approve-request/" + $scope.approve_request + "/?format=json", {"approved": approved})
        .success((function(data) {
          $scope.cert.status = data.cert_status;
            $scope.cert.waiting_for = '';
          return ($scope.approving = false);
        }))
        .error((function(data, status, headers) {
          $scope.approving = false;
          $scope.request_id = headers("x-request-id");
          return ($scope.approving_error = data);
        }));
    });
    $scope.hold = (function() {
      $scope.holding = true;
      $scope.revoking_error = undefined;
      return $http["post"]("/api/certificate/" + $routeParams.id + "/", {"action": "hold"})
        .success((function(data) {
          $scope.cert = data;
          return ($scope.holding = false);
        }))
        .error((function(data, status, headers) {
          $scope.holding = false;
          $scope.request_id = headers("x-request-id");
          return ($scope.revoking_error = data.detail);
        }));
    });
    $scope.unhold = (function() {
      $scope.unholding = true;
      $scope.revoking_error = undefined;
      return $http["post"]("/api/certificate/" + $routeParams.id + "/", {"action": "unhold"})
        .success((function(data) {
          $scope.cert = data;
          return ($scope.unholding = false);
        }))
        .error((function(data, status, headers) {
          $scope.unholding = false;
          $scope.request_id = headers("x-request-id");
          return ($scope.revoking_error = data.detail);
        }));
    });
    return ($scope.revoke = (function() {
      $scope.revoking = true;
      $scope.revoking_error = undefined;
      return $http["delete"]("/api/certificate/" + $routeParams.id + "/")
        .success((function(data) {
          $scope.cert = data;
          return ($scope.revoking = false);
        }))
        .error((function(data, status, headers) {
          $scope.revoking = false;
          $scope.request_id = headers("x-request-id");
          return ($scope.revoking_error = data.detail);
        }));
    }));
  })));


  console_app.controller("DomainsCtrl", list("$scope", "$http", (function($scope, $http) {
    return $http["get"]("/api/hosts/to-approve/?all&fields=id,host,validated,is_waiting_for_validation")
      .success((function(data) {
        return ($scope.domains = data);
      }));
  })));
  return console_app.controller("DomainCtrl", list("$scope", "$http", "$routeParams", (function($scope, $http, $routeParams) {
    var format_dates;
    format_dates = make_date_from_now("created", "updated");
    $http["get"]("/api/hosts/to-approve/" + $routeParams.id + "/?fields=__all__")
      .success((function(data) {
        return ($scope.domain = data);
      }));
    return $http["get"]("/api/hosts/to-approve/" + $routeParams.id + "/history/")
      .success((function(data) {
        var item, _i, _ref;
        _ref = data;
        for (_i = 0; _i < _ref.length; ++_i) {
          item = _ref[_i];
          format_dates(item);
          (function(match) {
            return (match ? (item.certificate_url = "#!/" + match[0]) : undefined);
          })(/certificate\/\d+/.exec(item.certificate_uri));
        }
        return ($scope.history = data);
      }));
  })));
})['call'](this);