import re

from django.utils.safestring import mark_safe
from django import template

register = template.Library()


@register.filter
def create_ticket_links(text):
    return mark_safe(re.sub(r'([A-Z]+-\d+)', r'<a href="https://st.yandex-team.ru/\1">\1</a>', text))
