from django.conf.urls import url
from django_yauth.decorators import yalogin_required

from intranet.crt.core.views import (RequestLinuxCertificate, NinjaView, server_error, index, ping,
                            migration_text, console, console_help)

urlpatterns = [
    url(r'^$', index, name='index'),
    url(r'^ping/?$', ping, name='ping'),
    url(r'^migration/$', migration_text, name='migration-text'),
    url(r'^console/$', console, name='console'),
    url(r'^console/help/$', console_help, name='console-help'),
    url(r'^ninja/$', NinjaView.as_view(), name='ninja'),
    url(r'^request/$', yalogin_required(RequestLinuxCertificate.as_view()), name='request-linux-certificate'),
]

handler500 = server_error
