PY3_LIBRARY(crt.core)

OWNER(g:tools-access)

PY_SRCS(
    admin.py
    apps.py
    auth.py
    ca/base.py
    ca/certum.py
    ca/exceptions.py
    ca/external_ca.py
    ca/globalsign.py
    ca/__init__.py
    ca/internal.py
    ca/registry.py
    ca/test.py
    ca/zeep_client.py
    context_processors.py
    controllers/assessor.py
    controllers/base.py
    controllers/certificates/assessor.py
    controllers/certificates/bank_pc.py
    controllers/certificates/bank_client_server.py
    controllers/certificates/base.py
    controllers/certificates/botik.py
    controllers/certificates/client_server.py
    controllers/certificates/courtecy_vpn.py
    controllers/certificates/host.py
    controllers/certificates/hypercube.py
    controllers/certificates/imdm.py
    controllers/certificates/__init__.py
    controllers/certificates/linux_pc.py
    controllers/certificates/linux_token.py
    controllers/certificates/mobvpn.py
    controllers/certificates/mdb.py
    controllers/certificates/ninja.py
    controllers/certificates/pc.py
    controllers/certificates/zomb_pc.py
    controllers/certificates/rc_server.py
    controllers/certificates/postamate.py
    controllers/certificates/sdc.py
    controllers/certificates/temp_pc.py
    controllers/certificates/tpm_smartcard_1c.py
    controllers/certificates/vpn_1d.py
    controllers/certificates/vpn_token.py
    controllers/certificates/win_pc_auto.py
    controllers/certificates/yc_server.py
    controllers/certificates/zombie.py
    controllers/certificates/win_wh_shared.py
    controllers/__init__.py
    fields.py
    forms.py
    __init__.py
    management/commands/calculate_5xx_exclude_internal_ca.py
    management/commands/check_if_certs_deployed.py
    management/commands/check_txt_records.py
    management/commands/create_alive_checkpoint.py
    management/commands/crt_oneoff_fill_hypercube_user.py
    management/commands/crt_oneoff_fill_revoker.py
    management/commands/crt_oneoff_migrate_old_ycserver.py
    management/commands/expiring_botik_certs_notify.py
    management/commands/expiring_host_certs_notify.py
    management/commands/__init__.py
    management/commands/issue_certificates.py
    management/commands/runmysql2pgsql.py
    management/commands/send_notifications_to_people.py
    management/__init__.py
    managers.py
    middleware.py
    models.py
    notifications.py
    query_parser.py
    signals.py
    templatetags/coretags.py
    templatetags/__init__.py
    urls.py
    utils.py
    views.py
)

RESOURCE_FILES(
    PREFIX intranet/crt/core/

    static/certificate.html
    static/css/console.css
    static/css/crt.css
    static/css/reset.css
    static/domain.html
    static/domains.html
    static/js/browser-detect.js
    static/js/console-to-remove.js
    static/js/crt.js
    static/js/jquery.min.js
    static/js/moment.min.js
    static/js/show-linux-alert.js
    static/search.html

    templates/404.html
    templates/500.html
    templates/base.html
    templates/console-help.html
    templates/console.html
    templates/emails/assessor_notify.html
    templates/emails/base.html
    templates/emails/certificate-for-abc-service-was-issued-and-private-key-has-uploaded-to-yav.html
    templates/emails/certificate-was-issued-and-private-key-has-uploaded-to-yav.html
    templates/emails/expire-linuxoids.html
    templates/emails/expire-people.html
    templates/emails/expire-soon.html
    templates/emails/expire-zombie.html
    templates/emails/expiring-host-certs-notify.html
    templates/emails/ssl-certificate-was-issued.html
    templates/emails/ssl-certificate-was-not-issued.html
    templates/emails/ssl-certificate-was-not-validated.html
    templates/host-certificate-expires-soon.txt
    templates/host-certificate-need-approve.txt
    templates/iphone-exchange-profile.xml
    templates/migration.html
    templates/ninja.html
    templates/openssl/ca.cnf
    templates/request_linux_certificate.html
    templates/rest_framework/api.html
    templates/tag-filter-is-broken.txt
 )

PEERDIR(
    intranet/crt/core/migrations
)

END()
