from intranet.crt.csr.base_config import BaseCsrConfig
from intranet.crt.csr.fields import (
    CommonNameSubjectField,
    EmailSubjectField,
    CountrySubjectField,
    LocalitySubjectField,
    UnitSubjectField,
    StateSubjectField,
    OrganizationSubjectField,
    OrganizationalUnitSubjectField,
    BasicConstraintsExtensionField,
    KeyUsageExtensionField,
    SansExtensionField,
    ExtendedKeyUsageExtensionField,
    DomainComponentSubjectFiled,
)


class HostCsrConfig(BaseCsrConfig):
    SUBJECT_ORDER = ['common_name', 'email', 'country', 'city', 'organization', 'unit']
    EXTENSION_ORDER = ['key_usage', 'extended_key_usage', 'sans']

    common_name = CommonNameSubjectField(required=True)
    email = EmailSubjectField(required=True)

    sans = SansExtensionField(required=True)

    country = CountrySubjectField(value='RU')
    city = LocalitySubjectField(value='Moscow')
    unit = UnitSubjectField(value='ITO')
    organization = OrganizationSubjectField(value='Yandex LLC')

    extended_key_usage = ExtendedKeyUsageExtensionField()
    key_usage = KeyUsageExtensionField(content_commitment=False)


class DeviceCertCsrConfig(BaseCsrConfig):
    SUBJECT_ORDER = ['common_name']
    EXTENSION_ORDER = ['basic_constraints', 'key_usage']

    common_name = CommonNameSubjectField(required=True)

    basic_constraints = BasicConstraintsExtensionField()
    key_usage = KeyUsageExtensionField(content_commitment=True)


class RcServerCsrConfig(DeviceCertCsrConfig):
    pass


class YcServerCsrConfig(DeviceCertCsrConfig):
    EXTENSION_ORDER = ['basic_constraints', 'key_usage', 'sans']

    sans = SansExtensionField(required=True)


class MdbCsrConfig(DeviceCertCsrConfig):
    EXTENSION_ORDER = ['basic_constraints', 'key_usage', 'sans']

    sans = SansExtensionField(required=True)


class PostamateCsrConfig(DeviceCertCsrConfig):
    unit = UnitSubjectField(value='postamate')


class SdcCsrConfig(DeviceCertCsrConfig):
    EXTENSION_ORDER = ['basic_constraints', 'key_usage', 'sans']

    sans = SansExtensionField(required=True)


class NinjaCsrConfig(DeviceCertCsrConfig):
    pass


class NinjaExchangeCsrConfig(DeviceCertCsrConfig):
    SUBJECT_ORDER = ['common_name', 'unit']

    unit = UnitSubjectField(value='MOBILE')


class HypercubeCsrConfig(NinjaCsrConfig):
    pass


class BotikCsrConfig(DeviceCertCsrConfig):
    SUBJECT_ORDER = ['common_name', 'email', 'organization', 'unit']

    email = EmailSubjectField(value='animals-report@yandex-team.ru')
    unit = UnitSubjectField(value='Network Operations')
    organization = OrganizationSubjectField(value='Yandex')


class FullSubjectCsrConfig(DeviceCertCsrConfig):
    SUBJECT_ORDER = ['common_name', 'email', 'country', 'state', 'city', 'organization', 'unit']

    email = EmailSubjectField(required=True)
    country = CountrySubjectField(required=True)
    city = LocalitySubjectField(required=True)
    unit = UnitSubjectField(required=True)

    state = StateSubjectField(value='Moscow')
    organization = OrganizationSubjectField(value='Yandex')


class AssessorCsrConfig(FullSubjectCsrConfig):
    unit = UnitSubjectField(value='ass')


class LinuxPcCsrConfig(FullSubjectCsrConfig):
    unit = UnitSubjectField(value='lpc')


class CourtecyVPNConfig(LinuxPcCsrConfig):
    pass


class Vpn1DCsrConfig(LinuxPcCsrConfig):
    pass


class ZombieCsrConfig(FullSubjectCsrConfig):
    unit = UnitSubjectField(value='zomb')


class TpmSmartcard1CSubjectCsrConfig(BaseCsrConfig):
    SUBJECT_ORDER = ['dc_3', 'dc_2', 'dc_1', 'cn_2', 'cn_1']

    cn_1 = CommonNameSubjectField(required=True)
    cn_2 = CommonNameSubjectField(required=True)
    dc_1 = DomainComponentSubjectFiled(required=True)
    dc_2 = DomainComponentSubjectFiled(required=True)
    dc_3 = DomainComponentSubjectFiled(required=True)


class TpmSmartcard1CForeignSubjectCsrConfig(BaseCsrConfig):
    SUBJECT_ORDER = ['dc_3', 'dc_2', 'dc_1', 'ou_1', 'cn_1']

    cn_1 = CommonNameSubjectField(required=True)
    ou_1 = OrganizationalUnitSubjectField(required=True)
    dc_1 = DomainComponentSubjectFiled(required=True)
    dc_2 = DomainComponentSubjectFiled(required=True)
    dc_3 = DomainComponentSubjectFiled(required=True)


class TempPcCsrConfig(DeviceCertCsrConfig):
    pass
